/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import org.gnu.pilotlink.AppInfo;
import org.gnu.pilotlink.Record;

public class AddressAppInfo
extends AppInfo {
    private String[] labels;
    private boolean[] labelRenamed;
    private String[] phoneLabels;
    private int country = 0;
    private int sortByCompany = 0;

    public AddressAppInfo() {
    }

    public AddressAppInfo(AppInfo appInfo) {
        super(appInfo);
    }

    @Override
    public void setBuffer(byte[] byArray) {
        int n;
        int n2;
        this.labels = new String[22];
        this.labelRenamed = new boolean[22];
        this.phoneLabels = new String[8];
        this.buffer = byArray;
        super.parseCategories();
        long l = Record.getLongAt(this.buffer, this.dataOffset);
        for (n2 = 0; n2 < 22; ++n2) {
            this.labelRenamed[n2] = (l & (long)(1 << n2)) != 0L;
        }
        n2 = this.dataOffset + 4;
        for (n = 0; n < 22; ++n) {
            this.labels[n] = Record.getStringAt(this.buffer, n2 + n * 16);
        }
        this.country = Record.getIntAt(this.buffer, n2 += 352);
        this.sortByCompany = this.buffer[n2 += 2];
        for (n = 3; n < 8; ++n) {
            this.phoneLabels[n - 3] = this.labels[n];
        }
        for (n = 19; n < 22; ++n) {
            this.phoneLabels[n - 19 + 5] = this.labels[n];
        }
    }

    @Override
    public byte[] getBuffer() {
        int n;
        super.createDefaultBuffer();
        long l = 0L;
        for (n = 0; n < 22; ++n) {
            if (!this.labelRenamed[n]) continue;
            l |= 1L << n;
        }
        n = this.dataOffset + 4;
        for (int i = 0; i < 22; ++i) {
            Record.setStringAt(this.buffer, this.labels[i], n + i * 16);
        }
        Record.setIntAt(this.buffer, this.country, n += 352);
        this.buffer[n += 2] = (byte)this.sortByCompany;
        return this.buffer;
    }

    public int getCountry() {
        return this.country;
    }

    public void setCountry(int n) {
        this.country = n;
    }

    public boolean getLabelRenamed(int n) {
        return this.labelRenamed[n];
    }

    public void setLabelRenamed(int n, boolean bl) {
        this.labelRenamed[n] = bl;
    }

    public String getLabel(int n) {
        return this.labels[n];
    }

    public void setLabel(int n, String string) {
        this.labels[n] = string;
    }

    public String getPhoneLabel(int n) {
        return this.phoneLabels[n];
    }

    public void setPhoneLabels(int n, String string) {
        this.phoneLabels[n] = string;
    }

    public boolean isSortByCompany() {
        return this.sortByCompany != 0;
    }

    public void setSortByCompany(boolean bl) {
        this.sortByCompany = bl ? 1 : 0;
    }
}

