; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i16_stride4_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,7]
; SSE-NEXT:    movdqa %xmm0, (%r8)
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i16_stride4_vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX1-NEXT:    vmovdqa %xmm0, (%r8)
; AVX1-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride4_vf2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,10,11,4,5,12,13,6,7,14,15]
; AVX512F-NEXT:    vmovdqa %xmm0, (%r8)
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,2,8,10,1,3,9,11]
; AVX512BW-NEXT:    vpermi2w %xmm1, %xmm0, %xmm2
; AVX512BW-NEXT:    vmovdqa %xmm2, (%r8)
; AVX512BW-NEXT:    retq
  %in.vec0 = load <2 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <2 x i16> %in.vec0, <2 x i16> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i16> %in.vec2, <2 x i16> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <4 x i16> %1, <4 x i16> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %interleaved.vec = shufflevector <8 x i16> %3, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm0, 16(%r8)
; SSE-NEXT:    movdqa %xmm2, (%r8)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride4_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[3,1,2,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,0,3,1,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[3,1,2,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,0,3,1,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%r8)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride4_vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,u,u,u,u,20,21,28,29,u,u,u,u,22,23,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,20,21,28,29,u,u,u,u,22,23,30,31,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride4_vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,1,3,5,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,2,3,6,7,10,11,14,15,16,17,20,21,24,25,28,29,18,19,22,23,26,27,30,31]
; AVX2-FAST-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride4_vf4:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,u,u,u,u,20,21,28,29,u,u,u,u,22,23,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,20,21,28,29,u,u,u,u,22,23,30,31,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride4_vf4:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,u,u,u,u,20,21,28,29,u,u,u,u,22,23,30,31]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,20,21,28,29,u,u,u,u,22,23,30,31,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride4_vf4:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,1,3,5,7]
; AVX512F-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,2,3,6,7,10,11,14,15,16,17,20,21,24,25,28,29,18,19,22,23,26,27,30,31]
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,4,8,12,1,5,9,13,2,6,10,14,3,7,11,15]
; AVX512BW-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vmovdqa %ymm0, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <4 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <4 x i16> %in.vec0, <4 x i16> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i16> %in.vec2, <4 x i16> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <8 x i16> %1, <8 x i16> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %interleaved.vec = shufflevector <16 x i16> %3, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rsi), %xmm1
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa (%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm0, 32(%r8)
; SSE-NEXT:    movdqa %xmm1, 48(%r8)
; SSE-NEXT:    movdqa %xmm5, 16(%r8)
; SSE-NEXT:    movdqa %xmm6, (%r8)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride4_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm3
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, (%r8)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i16_stride4_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-ONLY-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[0,2,0,2]
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15>
; AVX2-ONLY-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,2,0,2]
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm5 = <0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15,u,u,u,u>
; AVX2-ONLY-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX2-ONLY-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-ONLY-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 32(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride4_vf8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512F-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512F-NEXT:    vpermq {{.*#+}} ymm2 = ymm1[1,3,1,3]
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15>
; AVX512F-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[1,3,1,3]
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = <0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15,u,u,u,u>
; AVX512F-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2],ymm2[3],ymm4[4],ymm2[5],ymm4[6],ymm2[7]
; AVX512F-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,0,2]
; AVX512F-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,0,2]
; AVX512F-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,8,16,24,1,9,17,25,2,10,18,26,3,11,19,27,4,12,20,28,5,13,21,29,6,14,22,30,7,15,23,31]
; AVX512BW-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <8 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <8 x i16> %in.vec0, <8 x i16> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i16> %in.vec2, <8 x i16> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <16 x i16> %1, <16 x i16> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %interleaved.vec = shufflevector <32 x i16> %3, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa (%rsi), %xmm5
; SSE-NEXT:    movdqa 16(%rsi), %xmm6
; SSE-NEXT:    movdqa (%rdx), %xmm7
; SSE-NEXT:    movdqa 16(%rdx), %xmm4
; SSE-NEXT:    movdqa (%rcx), %xmm8
; SSE-NEXT:    movdqa 16(%rcx), %xmm9
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm8[0],xmm10[1],xmm8[1],xmm10[2],xmm8[2],xmm10[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm7[2],xmm5[3],xmm7[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm1, 96(%r8)
; SSE-NEXT:    movdqa %xmm6, 112(%r8)
; SSE-NEXT:    movdqa %xmm8, 64(%r8)
; SSE-NEXT:    movdqa %xmm10, 80(%r8)
; SSE-NEXT:    movdqa %xmm0, 32(%r8)
; SSE-NEXT:    movdqa %xmm5, 48(%r8)
; SSE-NEXT:    movdqa %xmm2, (%r8)
; SSE-NEXT:    movdqa %xmm3, 16(%r8)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride4_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm9[0],ymm2[1],ymm9[2],ymm2[3],ymm9[4],ymm2[5],ymm9[6],ymm2[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2],ymm5[3],ymm6[4],ymm5[5],ymm6[6],ymm5[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2],ymm6[3],ymm7[4],ymm6[5],ymm7[6],ymm6[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 32(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, (%r8)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i16_stride4_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %xmm8
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0],ymm2[1],ymm9[2],ymm2[3],ymm9[4],ymm2[5],ymm9[6],ymm2[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2],ymm5[3],ymm6[4],ymm5[5],ymm6[6],ymm5[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2],ymm6[3],ymm7[4],ymm6[5],ymm7[6],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm1[0],zero,xmm1[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 64(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 96(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm5, 32(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, (%r8)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride4_vf16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512F-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512F-NEXT:    vinserti32x4 $2, %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512F-NEXT:    vmovdqa 16(%rsi), %xmm4
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm5
; AVX512F-NEXT:    vmovdqa 16(%rdi), %xmm6
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; AVX512F-NEXT:    vinserti32x4 $2, %xmm7, %zmm4, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,8,24,9,25,10,26,11,27]
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm6, %zmm4
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512F-NEXT:    vinserti32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; AVX512F-NEXT:    vinserti32x4 $2, %xmm1, %zmm2, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm6, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,16,32,48,1,17,33,49,2,18,34,50,3,19,35,51,4,20,36,52,5,21,37,53,6,22,38,54,7,23,39,55]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,24,40,56,9,25,41,57,10,26,42,58,11,27,43,59,12,28,44,60,13,29,45,61,14,30,46,62,15,31,47,63]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <16 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <16 x i16> %in.vec0, <16 x i16> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i16> %in.vec2, <16 x i16> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <32 x i16> %1, <32 x i16> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %interleaved.vec = shufflevector <64 x i16> %3, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm11
; SSE-NEXT:    movdqa 32(%rdi), %xmm4
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa (%rsi), %xmm0
; SSE-NEXT:    movdqa 16(%rsi), %xmm3
; SSE-NEXT:    movdqa 32(%rsi), %xmm9
; SSE-NEXT:    movdqa (%rdx), %xmm7
; SSE-NEXT:    movdqa 16(%rdx), %xmm13
; SSE-NEXT:    movdqa 32(%rdx), %xmm10
; SSE-NEXT:    movdqa (%rcx), %xmm8
; SSE-NEXT:    movdqa 16(%rcx), %xmm14
; SSE-NEXT:    movdqa 32(%rcx), %xmm12
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm8[0],xmm15[1],xmm8[1],xmm15[2],xmm8[2],xmm15[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm0[4],xmm5[5],xmm0[5],xmm5[6],xmm0[6],xmm5[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; SSE-NEXT:    movdqa %xmm13, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm15[0],xmm7[1],xmm15[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm14[4],xmm13[5],xmm14[5],xmm13[6],xmm14[6],xmm13[7],xmm14[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm3[4],xmm11[5],xmm3[5],xmm11[6],xmm3[6],xmm11[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    punpckhdq {{.*#+}} xmm8 = xmm8[2],xmm13[2],xmm8[3],xmm13[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm13[0],xmm11[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm12[0],xmm15[1],xmm12[1],xmm15[2],xmm12[2],xmm15[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1],xmm13[2],xmm9[2],xmm13[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1]
; SSE-NEXT:    movdqa 48(%rdx), %xmm15
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm12[4],xmm10[5],xmm12[5],xmm10[6],xmm12[6],xmm10[7],xmm12[7]
; SSE-NEXT:    movdqa 48(%rcx), %xmm12
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    punpckhdq {{.*#+}} xmm9 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1]
; SSE-NEXT:    movdqa %xmm15, %xmm10
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; SSE-NEXT:    movdqa 48(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm10[0],xmm3[1],xmm10[1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm15 = xmm15[4],xmm12[4],xmm15[5],xmm12[5],xmm15[6],xmm12[6],xmm15[7],xmm12[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1]
; SSE-NEXT:    movdqa %xmm2, 224(%r8)
; SSE-NEXT:    movdqa %xmm1, 240(%r8)
; SSE-NEXT:    movdqa %xmm3, 192(%r8)
; SSE-NEXT:    movdqa %xmm0, 208(%r8)
; SSE-NEXT:    movdqa %xmm4, 160(%r8)
; SSE-NEXT:    movdqa %xmm9, 176(%r8)
; SSE-NEXT:    movdqa %xmm13, 128(%r8)
; SSE-NEXT:    movdqa %xmm14, 144(%r8)
; SSE-NEXT:    movdqa %xmm11, 96(%r8)
; SSE-NEXT:    movdqa %xmm8, 112(%r8)
; SSE-NEXT:    movdqa %xmm7, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movdqa %xmm5, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movdqa %xmm6, (%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride4_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm2[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm9, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0],ymm2[1],ymm11[2],ymm2[3],ymm11[4],ymm2[5],ymm11[6],ymm2[7]
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm3[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm3
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm9, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0],ymm3[1],ymm6[2],ymm3[3],ymm6[4],ymm3[5],ymm6[6],ymm3[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm9, %ymm6
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4],ymm6[5],ymm9[6],ymm6[7]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2],ymm7[3],ymm8[4],ymm7[5],ymm8[6],ymm7[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm8[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2],ymm8[3],ymm11[4],ymm8[5],ymm11[6],ymm8[7]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm5[0],zero,xmm5[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm9, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4],ymm4[5],ymm5[6],ymm4[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm5[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm9, %ymm5
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2],ymm5[3],ymm9[4],ymm5[5],ymm9[6],ymm5[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm1[0],zero,xmm1[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm9, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 64(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 160(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 128(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 224(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, (%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 32(%r8)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i16_stride4_vf32:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm2[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm9, %ymm2
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm11[0],ymm2[1],ymm11[2],ymm2[3],ymm11[4],ymm2[5],ymm11[6],ymm2[7]
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm3[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm3, %ymm6, %ymm3
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0],ymm3[1],ymm6[2],ymm3[3],ymm6[4],ymm3[5],ymm6[6],ymm3[7]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0],ymm6[1],ymm9[2],ymm6[3],ymm9[4],ymm6[5],ymm9[6],ymm6[7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2],ymm7[3],ymm8[4],ymm7[5],ymm8[6],ymm7[7]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm8[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm9[0],xmm10[0],xmm9[1],xmm10[1],xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0],ymm8[1],ymm11[2],ymm8[3],ymm11[4],ymm8[5],ymm11[6],ymm8[7]
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm5[0],zero,xmm5[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm9, %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4],ymm4[5],ymm5[6],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm5[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm9, %ymm5
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm9[0],ymm5[1],ymm9[2],ymm5[3],ymm9[4],ymm5[5],ymm9[6],ymm5[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm1[0],zero,xmm1[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm9, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 96(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm5, 64(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm4, 160(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm8, 128(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm7, 224(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 192(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: store_i16_stride4_vf32:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rcx), %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rcx), %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rdx), %xmm6
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm7, %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rsi), %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rsi), %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdi), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm4[4],xmm14[5],xmm4[5],xmm14[6],xmm4[6],xmm14[7],xmm4[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm14[0],xmm4[0],xmm14[1],xmm4[1],xmm14[2],xmm4[2],xmm14[3],xmm4[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm4[0],zero,xmm4[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm14, %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm4, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-ONLY-SLOW-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm13, %zmm4 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm9, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm10[0],zero,xmm10[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm13, %ymm10
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm9, %zmm10 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm9[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm11, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm5, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm7, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm1[0],zero,xmm1[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm5, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, 192(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: store_i16_stride4_vf32:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rcx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rcx), %xmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rdx), %xmm6
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm7, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rsi), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rsi), %xmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rsi), %xmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdi), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rdi), %xmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm4[4],xmm14[5],xmm4[5],xmm14[6],xmm4[6],xmm14[7],xmm4[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm14[0],xmm4[0],xmm14[1],xmm4[1],xmm14[2],xmm4[2],xmm14[3],xmm4[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm4[0],zero,xmm4[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm14, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm4, %zmm4
; AVX512F-ONLY-FAST-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm13, %zmm4 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm13, %zmm9, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm10[0],zero,xmm10[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm13, %ymm10
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm9, %zmm10 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm9[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm11, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm9, %zmm5, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm6[0],zero,xmm6[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm9, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm7[0],zero,xmm7[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm8, %ymm7
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm7, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm1[0],zero,xmm1[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm5, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, 192(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: store_i16_stride4_vf32:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rsi), %xmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rdi), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm8, %ymm4
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rcx), %xmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rdx), %xmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512DQ-SLOW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-SLOW-NEXT:    kmovw %eax, %k1
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm15, %zmm13, %zmm0 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm10[4],xmm7[4],xmm10[5],xmm7[5],xmm10[6],xmm7[6],xmm10[7],xmm7[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm7[0],xmm10[1],xmm7[1],xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm7[0],zero,xmm7[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm10, %ymm7
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm7, %zmm7
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm10[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm13, %ymm10
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm11[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm10, %zmm11, %zmm7 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm5, %zmm5
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm6[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm10, %ymm6
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm8[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm9, %ymm8
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm6, %zmm8, %zmm5 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm8, %ymm6
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm1, %zmm1
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm2, %zmm3, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, 64(%r8)
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: store_i16_stride4_vf32:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rsi), %xmm7
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rsi), %xmm5
; AVX512DQ-FAST-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rdi), %xmm10
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rdi), %xmm6
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm8, %ymm4
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rcx), %xmm13
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rcx), %xmm11
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512DQ-FAST-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rdx), %xmm14
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rdx), %xmm12
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512DQ-FAST-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm15, %zmm13, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm10[4],xmm7[4],xmm10[5],xmm7[5],xmm10[6],xmm7[6],xmm10[7],xmm7[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm7[0],xmm10[1],xmm7[1],xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm7[0],zero,xmm7[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm10, %ymm7
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm13, %zmm7, %zmm7
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm10[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm13, %ymm10
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm12 = xmm11[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm10, %zmm11, %zmm7 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm10, %zmm5, %zmm5
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm6[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm10, %ymm6
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm8[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm9, %ymm8
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm6, %zmm8, %zmm5 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm8 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm8, %ymm6
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm1, %zmm1
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm6, %ymm2
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm2, %zmm3, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, 192(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, 64(%r8)
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,0,32,u,u,1,33,u,u,2,34,u,u,3,35,u,u,4,36,u,u,5,37,u,u,6,38,u,u,7,39>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <0,32,u,u,1,33,u,u,2,34,u,u,3,35,u,u,4,36,u,u,5,37,u,u,6,38,u,u,7,39,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm5
; AVX512BW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,8,40,u,u,9,41,u,u,10,42,u,u,11,43,u,u,12,44,u,u,13,45,u,u,14,46,u,u,15,47>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <8,40,u,u,9,41,u,u,10,42,u,u,11,43,u,u,12,44,u,u,13,45,u,u,14,46,u,u,15,47,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,16,48,u,u,17,49,u,u,18,50,u,u,19,51,u,u,20,52,u,u,21,53,u,u,22,54,u,u,23,55>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <16,48,u,u,17,49,u,u,18,50,u,u,19,51,u,u,20,52,u,u,21,53,u,u,22,54,u,u,23,55,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,24,56,u,u,25,57,u,u,26,58,u,u,27,59,u,u,28,60,u,u,29,61,u,u,30,62,u,u,31,63>
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <24,56,u,u,25,57,u,u,26,58,u,u,27,59,u,u,28,60,u,u,29,61,u,u,30,62,u,u,31,63,u,u>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <32 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <32 x i16> %in.vec0, <32 x i16> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i16> %in.vec2, <32 x i16> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <64 x i16> %1, <64 x i16> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %interleaved.vec = shufflevector <128 x i16> %3, <128 x i16> poison, <128 x i32> <i32 0, i32 32, i32 64, i32 96, i32 1, i32 33, i32 65, i32 97, i32 2, i32 34, i32 66, i32 98, i32 3, i32 35, i32 67, i32 99, i32 4, i32 36, i32 68, i32 100, i32 5, i32 37, i32 69, i32 101, i32 6, i32 38, i32 70, i32 102, i32 7, i32 39, i32 71, i32 103, i32 8, i32 40, i32 72, i32 104, i32 9, i32 41, i32 73, i32 105, i32 10, i32 42, i32 74, i32 106, i32 11, i32 43, i32 75, i32 107, i32 12, i32 44, i32 76, i32 108, i32 13, i32 45, i32 77, i32 109, i32 14, i32 46, i32 78, i32 110, i32 15, i32 47, i32 79, i32 111, i32 16, i32 48, i32 80, i32 112, i32 17, i32 49, i32 81, i32 113, i32 18, i32 50, i32 82, i32 114, i32 19, i32 51, i32 83, i32 115, i32 20, i32 52, i32 84, i32 116, i32 21, i32 53, i32 85, i32 117, i32 22, i32 54, i32 86, i32 118, i32 23, i32 55, i32 87, i32 119, i32 24, i32 56, i32 88, i32 120, i32 25, i32 57, i32 89, i32 121, i32 26, i32 58, i32 90, i32 122, i32 27, i32 59, i32 91, i32 123, i32 28, i32 60, i32 92, i32 124, i32 29, i32 61, i32 93, i32 125, i32 30, i32 62, i32 94, i32 126, i32 31, i32 63, i32 95, i32 127>
  store <128 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride4_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride4_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $184, %rsp
; SSE-NEXT:    movdqa (%rdi), %xmm10
; SSE-NEXT:    movdqa 16(%rdi), %xmm11
; SSE-NEXT:    movdqa 32(%rdi), %xmm12
; SSE-NEXT:    movdqa 48(%rdi), %xmm13
; SSE-NEXT:    movdqa (%rsi), %xmm5
; SSE-NEXT:    movdqa 16(%rsi), %xmm2
; SSE-NEXT:    movdqa 32(%rsi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm6
; SSE-NEXT:    movdqa 16(%rdx), %xmm4
; SSE-NEXT:    movdqa 32(%rdx), %xmm1
; SSE-NEXT:    movdqa (%rcx), %xmm7
; SSE-NEXT:    movdqa 16(%rcx), %xmm8
; SSE-NEXT:    movdqa 32(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm10, %xmm14
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm5[0],xmm14[1],xmm5[1],xmm14[2],xmm5[2],xmm14[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm14, %xmm15
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm9[0],xmm15[1],xmm9[1]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm7[4],xmm6[5],xmm7[5],xmm6[6],xmm7[6],xmm6[7],xmm7[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm5[4],xmm10[5],xmm5[5],xmm10[6],xmm5[6],xmm10[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm6[2],xmm10[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm11, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm2[4],xmm11[5],xmm2[5],xmm11[6],xmm2[6],xmm11[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm4[2],xmm11[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdx), %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE-NEXT:    movdqa 48(%rcx), %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm0[4],xmm12[5],xmm0[5],xmm12[6],xmm0[6],xmm12[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm12 = xmm12[2],xmm1[2],xmm12[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movdqa 48(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm1[0],xmm14[1],xmm1[1],xmm14[2],xmm1[2],xmm14[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm14 = xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm13 = xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdx), %xmm0
; SSE-NEXT:    movdqa 64(%rcx), %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    movdqa 64(%rdi), %xmm10
; SSE-NEXT:    movdqa 64(%rsi), %xmm5
; SSE-NEXT:    movdqa %xmm10, %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm12 = xmm12[0],xmm5[0],xmm12[1],xmm5[1],xmm12[2],xmm5[2],xmm12[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm12 = xmm12[2],xmm3[2],xmm12[3],xmm3[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm5[4],xmm10[5],xmm5[5],xmm10[6],xmm5[6],xmm10[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm10 = xmm10[2],xmm0[2],xmm10[3],xmm0[3]
; SSE-NEXT:    movdqa 80(%rdx), %xmm0
; SSE-NEXT:    movdqa 80(%rcx), %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; SSE-NEXT:    movdqa 80(%rdi), %xmm5
; SSE-NEXT:    movdqa 80(%rsi), %xmm7
; SSE-NEXT:    movdqa %xmm5, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm7[0],xmm15[1],xmm7[1],xmm15[2],xmm7[2],xmm15[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm15 = xmm15[2],xmm6[2],xmm15[3],xmm6[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm7[4],xmm5[5],xmm7[5],xmm5[6],xmm7[6],xmm5[7],xmm7[7]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm0[2],xmm5[3],xmm0[3]
; SSE-NEXT:    movdqa 96(%rdx), %xmm1
; SSE-NEXT:    movdqa 96(%rcx), %xmm4
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movdqa 96(%rdi), %xmm3
; SSE-NEXT:    movdqa 96(%rsi), %xmm7
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm6, %xmm13
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm0[0],xmm13[1],xmm0[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm6 = xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm1[0],xmm11[1],xmm1[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movdqa 112(%rdx), %xmm2
; SSE-NEXT:    movdqa 112(%rcx), %xmm9
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; SSE-NEXT:    movdqa 112(%rdi), %xmm0
; SSE-NEXT:    movdqa 112(%rsi), %xmm8
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm7[2],xmm1[3],xmm7[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm9[4],xmm2[5],xmm9[5],xmm2[6],xmm9[6],xmm2[7],xmm9[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm0, 496(%r8)
; SSE-NEXT:    movdqa %xmm7, 480(%r8)
; SSE-NEXT:    movdqa %xmm1, 464(%r8)
; SSE-NEXT:    movdqa %xmm4, 448(%r8)
; SSE-NEXT:    movdqa %xmm3, 432(%r8)
; SSE-NEXT:    movdqa %xmm11, 416(%r8)
; SSE-NEXT:    movdqa %xmm6, 400(%r8)
; SSE-NEXT:    movdqa %xmm13, 384(%r8)
; SSE-NEXT:    movdqa %xmm5, 368(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r8)
; SSE-NEXT:    movdqa %xmm15, 336(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r8)
; SSE-NEXT:    movdqa %xmm10, 304(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r8)
; SSE-NEXT:    movdqa %xmm12, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movdqa %xmm14, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    addq $184, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride4_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $40, %rsp
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX1-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm12[0],zero,xmm12[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm2[1],ymm12[2],ymm2[3],ymm12[4],ymm2[5],ymm12[6],ymm2[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm3[1],ymm4[2],ymm3[3],ymm4[4],ymm3[5],ymm4[6],ymm3[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 80(%rcx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm4[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa 80(%rsi), %xmm13
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm12[0],zero,xmm12[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm15, %ymm15
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0],ymm4[1],ymm15[2],ymm4[3],ymm15[4],ymm4[5],ymm15[6],ymm4[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm7[0],zero,xmm7[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm13, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2],ymm5[3],ymm7[4],ymm5[5],ymm7[6],ymm5[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm7[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm13, %ymm7
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm11[0],xmm15[1],xmm11[1],xmm15[2],xmm11[2],xmm15[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm13[0],ymm7[1],ymm13[2],ymm7[3],ymm13[4],ymm7[5],ymm13[6],ymm7[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm15[4],xmm11[4],xmm15[5],xmm11[5],xmm15[6],xmm11[6],xmm15[7],xmm11[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3],ymm10[4],ymm9[5],ymm10[6],ymm9[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm11[0],zero,xmm11[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2],ymm10[3],ymm11[4],ymm10[5],ymm11[6],ymm10[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm6
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm11, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm8[0],ymm6[1],ymm8[2],ymm6[3],ymm8[4],ymm6[5],ymm8[6],ymm6[7]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rcx), %xmm11
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdx), %xmm12
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm8[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm13, %ymm8
; AVX1-ONLY-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm15[0],zero,xmm15[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0],ymm8[1],ymm0[2],ymm8[3],ymm0[4],ymm8[5],ymm0[6],ymm8[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm11, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm0[1],ymm11[2],ymm0[3],ymm11[4],ymm0[5],ymm11[6],ymm0[7]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdx), %xmm13
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm1[0],xmm13[1],xmm1[1],xmm13[2],xmm1[2],xmm13[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm14, %ymm12
; AVX1-ONLY-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4],ymm12[5],ymm0[6],ymm12[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm14
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm15
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2],ymm13[3],ymm0[4],ymm13[5],ymm0[6],ymm13[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 480(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 448(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 416(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 384(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 224(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 192(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 160(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 128(%r8)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 352(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX1-ONLY-NEXT:    addq $40, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i16_stride4_vf64:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $40, %rsp
; AVX2-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2],ymm0[3],ymm5[4],ymm0[5],ymm5[6],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX2-ONLY-NEXT:    vmovdqa 64(%rsi), %xmm5
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm12[0],zero,xmm12[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm12, %ymm13, %ymm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0],ymm2[1],ymm12[2],ymm2[3],ymm12[4],ymm2[5],ymm12[6],ymm2[7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm5 = xmm4[0],zero,xmm4[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0],ymm3[1],ymm4[2],ymm3[3],ymm4[4],ymm3[5],ymm4[6],ymm3[7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 80(%rcx), %xmm5
; AVX2-ONLY-NEXT:    vmovdqa 80(%rdx), %xmm7
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm4[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm12, %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 80(%rsi), %xmm13
; AVX2-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm12[0],zero,xmm12[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm12, %ymm15, %ymm15
; AVX2-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0],ymm4[1],ymm15[2],ymm4[3],ymm15[4],ymm4[5],ymm15[6],ymm4[7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm7, %ymm5
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm7[0],zero,xmm7[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm13, %ymm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0],ymm5[1],ymm7[2],ymm5[3],ymm7[4],ymm5[5],ymm7[6],ymm5[7]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm7[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm13, %ymm7
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm11[0],xmm15[1],xmm11[1],xmm15[2],xmm11[2],xmm15[3],xmm11[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm13[0],zero,xmm13[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm13[0],ymm7[1],ymm13[2],ymm7[3],ymm13[4],ymm7[5],ymm13[6],ymm7[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm15[4],xmm11[4],xmm15[5],xmm11[5],xmm15[6],xmm11[6],xmm15[7],xmm11[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2],ymm9[3],ymm10[4],ymm9[5],ymm10[6],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm8[0],xmm6[0],xmm8[1],xmm6[1],xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm10[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm10, %ymm11, %ymm10
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm11[0],zero,xmm11[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm13, %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2],ymm10[3],ymm11[4],ymm10[5],ymm11[6],ymm10[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm8, %ymm6
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm11 = xmm8[0],zero,xmm8[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm11, %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0],ymm6[1],ymm8[2],ymm6[3],ymm8[4],ymm6[5],ymm8[6],ymm6[7]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rcx), %xmm11
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdx), %xmm12
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm8[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm13, %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 96(%rsi), %xmm13
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm15[0],zero,xmm15[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm0[0],ymm8[1],ymm0[2],ymm8[3],ymm0[4],ymm8[5],ymm0[6],ymm8[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm11, %ymm0
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm11[0],zero,xmm11[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm12, %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0],ymm0[1],ymm11[2],ymm0[3],ymm11[4],ymm0[5],ymm11[6],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqa 112(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa 112(%rdx), %xmm13
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm1[0],xmm13[1],xmm1[1],xmm13[2],xmm1[2],xmm13[3],xmm1[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm12, %ymm14, %ymm12
; AVX2-ONLY-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX2-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0],ymm12[1],ymm0[2],ymm12[3],ymm0[4],ymm12[5],ymm0[6],ymm12[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %xmm14
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2],ymm13[3],ymm0[4],ymm13[5],ymm0[6],ymm13[7]
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[0,0,1,1]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2],ymm1[3],ymm2[4],ymm1[5],ymm2[6],ymm1[7]
; AVX2-ONLY-NEXT:    vmovdqa %ymm1, 32(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm4, 480(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm12, 448(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm11, 416(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm8, 384(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 224(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm10, 192(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm9, 160(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm7, 128(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm5, 352(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-ONLY-NEXT:    addq $40, %rsp
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: store_i16_stride4_vf64:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %xmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rcx), %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rcx), %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rdx), %xmm6
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm7, %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rsi), %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rsi), %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdi), %xmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm3[4],xmm14[5],xmm3[5],xmm14[6],xmm3[6],xmm14[7],xmm3[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm14[0],xmm3[0],xmm14[1],xmm3[1],xmm14[2],xmm3[2],xmm14[3],xmm3[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm14, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm3, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-ONLY-SLOW-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm9, %zmm17 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm14
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm9[4],xmm14[5],xmm9[5],xmm14[6],xmm9[6],xmm14[7],xmm9[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm14[0],xmm9[0],xmm14[1],xmm9[1],xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm9[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm14, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm9, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm9[4],xmm15[5],xmm9[5],xmm15[6],xmm9[6],xmm15[7],xmm9[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm0[0],zero,xmm0[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm15[0],xmm9[0],xmm15[1],xmm9[1],xmm15[2],xmm9[2],xmm15[3],xmm9[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm9[0],zero,xmm9[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm15, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm9, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm14, %zmm18 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 112(%rdx), %xmm14
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm0[4],xmm14[5],xmm0[5],xmm14[6],xmm0[6],xmm14[7],xmm0[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm14, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm3, %ymm16, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm14[0],zero,xmm14[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm14, %ymm15, %ymm14
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm14, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm19 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm15
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm15[4],xmm3[4],xmm15[5],xmm3[5],xmm15[6],xmm3[6],xmm15[7],xmm3[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm9[0],zero,xmm9[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm9, %ymm16, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm15[0],xmm3[0],xmm15[1],xmm3[1],xmm15[2],xmm3[2],xmm15[3],xmm3[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm15, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 80(%rdx), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm9[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm9, %ymm16, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 80(%rsi), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm9
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm9[4],xmm3[4],xmm9[5],xmm3[5],xmm9[6],xmm3[6],xmm9[7],xmm3[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm14[0],zero,xmm14[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm14, %ymm16, %ymm14
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm9[0],xmm3[0],xmm9[1],xmm3[1],xmm9[2],xmm3[2],xmm9[3],xmm3[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm9, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm14, %zmm3, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm3[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm9, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm13[4],xmm12[4],xmm13[5],xmm12[5],xmm13[6],xmm12[6],xmm13[7],xmm12[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm9, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm9, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm9, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm6, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm5 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %xmm20, %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[0,0,1,1]
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm6, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm1[0],zero,xmm1[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm6, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX512F-ONLY-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm2[0],zero,xmm2[1],zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm4, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, 128(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, 320(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 256(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, 448(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, 384(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, 64(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: store_i16_stride4_vf64:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %xmm20
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rcx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rcx), %xmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rdx), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rdx), %xmm6
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm7, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rsi), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rsi), %xmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rsi), %xmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdi), %xmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rdi), %xmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 32(%rdi), %xmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm3[4],xmm14[5],xmm3[5],xmm14[6],xmm3[6],xmm14[7],xmm3[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm14[0],xmm3[0],xmm14[1],xmm3[1],xmm14[2],xmm3[2],xmm14[3],xmm3[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm14 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm14, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm3, %zmm17
; AVX512F-ONLY-FAST-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm9, %zmm17 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 96(%rcx), %xmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 96(%rdx), %xmm14
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm9[4],xmm14[5],xmm9[5],xmm14[6],xmm9[6],xmm14[7],xmm9[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm14[0],xmm9[0],xmm14[1],xmm9[1],xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm9[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm14, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm9, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 96(%rsi), %xmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm9[4],xmm15[5],xmm9[5],xmm15[6],xmm9[6],xmm15[7],xmm9[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm0[0],zero,xmm0[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm15[0],xmm9[0],xmm15[1],xmm9[1],xmm15[2],xmm9[2],xmm15[3],xmm9[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm9[0],zero,xmm9[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm15, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm9, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm14, %zmm18 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 112(%rdx), %xmm14
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm0[4],xmm14[5],xmm0[5],xmm14[6],xmm0[6],xmm14[7],xmm0[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm14, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 112(%rdi), %xmm15
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm3, %ymm16, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm14[0],zero,xmm14[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm15, %ymm14
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm14, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm19 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rdx), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rsi), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rdi), %xmm15
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm15[4],xmm3[4],xmm15[5],xmm3[5],xmm15[6],xmm3[6],xmm15[7],xmm3[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm9[0],zero,xmm9[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm9, %ymm16, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm15[0],xmm3[0],xmm15[1],xmm3[1],xmm15[2],xmm3[2],xmm15[3],xmm3[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm15 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm15, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm15 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 80(%rdx), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm9[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm9, %ymm16, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 80(%rsi), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 80(%rdi), %xmm9
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm9[4],xmm3[4],xmm9[5],xmm3[5],xmm9[6],xmm3[6],xmm9[7],xmm3[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm14[0],zero,xmm14[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm14, %ymm16, %ymm14
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm9[0],xmm3[0],xmm9[1],xmm3[1],xmm9[2],xmm3[2],xmm9[3],xmm3[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm9, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm14, %zmm3, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm16 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm3[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm9, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm13[4],xmm12[4],xmm13[5],xmm12[5],xmm13[6],xmm12[6],xmm13[7],xmm12[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm9 = xmm3[0],zero,xmm3[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm9, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm9[0],zero,xmm9[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm10, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm9, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm3 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm9, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm7 = xmm6[0],zero,xmm6[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm6, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm5 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %xmm20, %xmm7
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[0,0,1,1]
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm6, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm1[0],zero,xmm1[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm6, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX512F-ONLY-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm2[0],zero,xmm2[1],zero
; AVX512F-ONLY-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm4, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 192(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, 128(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, 320(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, 256(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, 448(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, 384(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, 64(%r8)
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: store_i16_stride4_vf64:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rsi), %xmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm6, %ymm4
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rcx), %xmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm6[4],xmm13[5],xmm6[5],xmm13[6],xmm6[6],xmm13[7],xmm6[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm6[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm13, %ymm6
; AVX512DQ-SLOW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-SLOW-NEXT:    kmovw %eax, %k1
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm15, %zmm6, %zmm17 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm13
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm6[4],xmm13[5],xmm6[5],xmm13[6],xmm6[6],xmm13[7],xmm6[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm13, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm6, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm13[4],xmm15[5],xmm13[5],xmm15[6],xmm13[6],xmm15[7],xmm13[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm0[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1],xmm15[2],xmm13[2],xmm15[3],xmm13[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm13[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm0, %zmm13, %zmm18 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 112(%rdi), %xmm13
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm0[4],xmm13[5],xmm0[5],xmm13[6],xmm0[6],xmm13[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm13[0],xmm0[0],xmm13[1],xmm0[1],xmm13[2],xmm0[2],xmm13[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm13, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm19
; AVX512DQ-SLOW-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 112(%rdx), %xmm15
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm15[4],xmm0[4],xmm15[5],xmm0[5],xmm15[6],xmm0[6],xmm15[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm6[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm6, %ymm16, %ymm6
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm15, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm6, %zmm0, %zmm19 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm16 = xmm13[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm13, %ymm16, %ymm13
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm13, %zmm0, %zmm15 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa 80(%rsi), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm13[0],zero,xmm13[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm13, %ymm16, %ymm13
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm0, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 80(%rdx), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm20 = xmm13[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm13, %ymm20, %ymm13
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm13, %zmm0, %zmm16 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm10, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm6, %zmm10
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm6[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm11, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm0, %zmm6, %zmm10 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm0
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm5, %zmm6, %zmm0 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512DQ-SLOW-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm1, %zmm1
; AVX512DQ-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX512DQ-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm2, %zmm3, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, 192(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, 320(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, 256(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm19, 448(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, 384(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm17, 64(%r8)
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: store_i16_stride4_vf64:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rsi), %xmm5
; AVX512DQ-FAST-NEXT:    vmovdqa (%rdi), %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm4[0],zero,xmm4[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm6, %ymm4
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rcx), %xmm6
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rcx), %xmm8
; AVX512DQ-FAST-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rdx), %xmm13
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rdx), %xmm14
; AVX512DQ-FAST-NEXT:    vmovdqa 48(%rdx), %xmm9
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm6[4],xmm13[5],xmm6[5],xmm13[6],xmm6[6],xmm13[7],xmm6[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm15[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm6[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm13, %ymm6
; AVX512DQ-FAST-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm15, %zmm6, %zmm17 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa 96(%rsi), %xmm6
; AVX512DQ-FAST-NEXT:    vmovdqa 96(%rdi), %xmm13
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm6[4],xmm13[5],xmm6[5],xmm13[6],xmm6[6],xmm13[7],xmm6[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm13, %ymm6
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm6, %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqa 96(%rcx), %xmm13
; AVX512DQ-FAST-NEXT:    vmovdqa 96(%rdx), %xmm15
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm13[4],xmm15[5],xmm13[5],xmm15[6],xmm13[6],xmm15[7],xmm13[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm0[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm0, %ymm16, %ymm0
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm15[0],xmm13[0],xmm15[1],xmm13[1],xmm15[2],xmm13[2],xmm15[3],xmm13[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm13[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm15, %ymm13
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm0, %zmm13, %zmm18 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 112(%rdi), %xmm13
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm13[4],xmm0[4],xmm13[5],xmm0[5],xmm13[6],xmm0[6],xmm13[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm13[0],xmm0[0],xmm13[1],xmm0[1],xmm13[2],xmm0[2],xmm13[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm13, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm19
; AVX512DQ-FAST-NEXT:    vmovdqa 112(%rcx), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 112(%rdx), %xmm15
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm15[4],xmm0[4],xmm15[5],xmm0[5],xmm15[6],xmm0[6],xmm15[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm6[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm6, %ymm16, %ymm6
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm15, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm6, %zmm0, %zmm19 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%rsi), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm15[0],zero,xmm15[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm15, %ymm16, %ymm15
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm16 = xmm13[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm13, %ymm16, %ymm13
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm13, %zmm0, %zmm15 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa 80(%rsi), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 80(%rdi), %xmm6
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm16 = xmm13[0],zero,xmm13[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm13, %ymm16, %ymm13
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm13, %zmm0, %zmm16
; AVX512DQ-FAST-NEXT:    vmovdqa 80(%rcx), %xmm0
; AVX512DQ-FAST-NEXT:    vmovdqa 80(%rdx), %xmm6
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm20 = xmm13[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm13, %ymm20, %ymm13
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm13, %zmm0, %zmm16 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm10 = xmm6[0],zero,xmm6[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm10, %ymm6
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm6, %zmm10
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm6[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm11, %ymm6
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm0, %zmm6, %zmm10 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm0[0],zero,xmm0[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm6, %ymm0
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm7, %ymm6
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm5, %zmm6, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm6, %ymm5
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512DQ-FAST-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm1, %zmm1
; AVX512DQ-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,0,1,1]
; AVX512DQ-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm2, %zmm3, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, 192(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, 128(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm16, 320(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, 256(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm19, 448(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm18, 384(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm17, 64(%r8)
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride4_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,8,40,u,u,9,41,u,u,10,42,u,u,11,43,u,u,12,44,u,u,13,45,u,u,14,46,u,u,15,47>
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm8, %zmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <8,40,u,u,9,41,u,u,10,42,u,u,11,43,u,u,12,44,u,u,13,45,u,u,14,46,u,u,15,47,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm10, %zmm11
; AVX512BW-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,0,32,u,u,1,33,u,u,2,34,u,u,3,35,u,u,4,36,u,u,5,37,u,u,6,38,u,u,7,39>
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm9, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <0,32,u,u,1,33,u,u,2,34,u,u,3,35,u,u,4,36,u,u,5,37,u,u,6,38,u,u,7,39,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm13, %zmm14
; AVX512BW-NEXT:    vmovdqa32 %zmm12, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,24,56,u,u,25,57,u,u,26,58,u,u,27,59,u,u,28,60,u,u,29,61,u,u,30,62,u,u,31,63>
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm12, %zmm15
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <24,56,u,u,25,57,u,u,26,58,u,u,27,59,u,u,28,60,u,u,29,61,u,u,30,62,u,u,31,63,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm16, %zmm17
; AVX512BW-NEXT:    vmovdqa32 %zmm15, %zmm17 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <u,u,16,48,u,u,17,49,u,u,18,50,u,u,19,51,u,u,20,52,u,u,21,53,u,u,22,54,u,u,23,55>
; AVX512BW-NEXT:    vpermt2w %zmm6, %zmm15, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <16,48,u,u,17,49,u,u,18,50,u,u,19,51,u,u,20,52,u,u,21,53,u,u,22,54,u,u,23,55,u,u>
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm8
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqa32 %zmm8, %zmm10 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm9
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm13
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm13 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm5, %zmm12
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm1, %zmm16
; AVX512BW-NEXT:    vmovdqa32 %zmm12, %zmm16 {%k1}
; AVX512BW-NEXT:    vpermt2w %zmm7, %zmm15, %zmm5
; AVX512BW-NEXT:    vpermt2w %zmm3, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqa32 %zmm5, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <64 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i16>, ptr %in.vecptr3, align 64
  %1 = shufflevector <64 x i16> %in.vec0, <64 x i16> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i16> %in.vec2, <64 x i16> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <128 x i16> %1, <128 x i16> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %interleaved.vec = shufflevector <256 x i16> %3, <256 x i16> poison, <256 x i32> <i32 0, i32 64, i32 128, i32 192, i32 1, i32 65, i32 129, i32 193, i32 2, i32 66, i32 130, i32 194, i32 3, i32 67, i32 131, i32 195, i32 4, i32 68, i32 132, i32 196, i32 5, i32 69, i32 133, i32 197, i32 6, i32 70, i32 134, i32 198, i32 7, i32 71, i32 135, i32 199, i32 8, i32 72, i32 136, i32 200, i32 9, i32 73, i32 137, i32 201, i32 10, i32 74, i32 138, i32 202, i32 11, i32 75, i32 139, i32 203, i32 12, i32 76, i32 140, i32 204, i32 13, i32 77, i32 141, i32 205, i32 14, i32 78, i32 142, i32 206, i32 15, i32 79, i32 143, i32 207, i32 16, i32 80, i32 144, i32 208, i32 17, i32 81, i32 145, i32 209, i32 18, i32 82, i32 146, i32 210, i32 19, i32 83, i32 147, i32 211, i32 20, i32 84, i32 148, i32 212, i32 21, i32 85, i32 149, i32 213, i32 22, i32 86, i32 150, i32 214, i32 23, i32 87, i32 151, i32 215, i32 24, i32 88, i32 152, i32 216, i32 25, i32 89, i32 153, i32 217, i32 26, i32 90, i32 154, i32 218, i32 27, i32 91, i32 155, i32 219, i32 28, i32 92, i32 156, i32 220, i32 29, i32 93, i32 157, i32 221, i32 30, i32 94, i32 158, i32 222, i32 31, i32 95, i32 159, i32 223, i32 32, i32 96, i32 160, i32 224, i32 33, i32 97, i32 161, i32 225, i32 34, i32 98, i32 162, i32 226, i32 35, i32 99, i32 163, i32 227, i32 36, i32 100, i32 164, i32 228, i32 37, i32 101, i32 165, i32 229, i32 38, i32 102, i32 166, i32 230, i32 39, i32 103, i32 167, i32 231, i32 40, i32 104, i32 168, i32 232, i32 41, i32 105, i32 169, i32 233, i32 42, i32 106, i32 170, i32 234, i32 43, i32 107, i32 171, i32 235, i32 44, i32 108, i32 172, i32 236, i32 45, i32 109, i32 173, i32 237, i32 46, i32 110, i32 174, i32 238, i32 47, i32 111, i32 175, i32 239, i32 48, i32 112, i32 176, i32 240, i32 49, i32 113, i32 177, i32 241, i32 50, i32 114, i32 178, i32 242, i32 51, i32 115, i32 179, i32 243, i32 52, i32 116, i32 180, i32 244, i32 53, i32 117, i32 181, i32 245, i32 54, i32 118, i32 182, i32 246, i32 55, i32 119, i32 183, i32 247, i32 56, i32 120, i32 184, i32 248, i32 57, i32 121, i32 185, i32 249, i32 58, i32 122, i32 186, i32 250, i32 59, i32 123, i32 187, i32 251, i32 60, i32 124, i32 188, i32 252, i32 61, i32 125, i32 189, i32 253, i32 62, i32 126, i32 190, i32 254, i32 63, i32 127, i32 191, i32 255>
  store <256 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX2: {{.*}}
; AVX512: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
