_onefetch() {
    local i cur prev opts cmd
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"
    cmd=""
    opts=""

    for i in ${COMP_WORDS[@]}
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="onefetch"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        onefetch)
            opts="-d -e -E -T -t -z -c -a -i -o -l -p -h -V --disabled-fields --no-title --number-of-authors --number-of-languages --number-of-file-churns --churn-pool-size --exclude --no-bots --no-merges --email --include-hidden --type --text-colors --iso-time --number-separator --no-bold --ascii-input --ascii-colors --ascii-language --true-color --image --image-protocol --color-resolution --no-color-palette --no-art --output --generate --languages --package-managers --help --version [INPUT]"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --disabled-fields)
                    COMPREPLY=($(compgen -W "project description head pending version created languages dependencies authors last-change contributors url commits churn lines-of-code size license" -- "${cur}"))
                    return 0
                    ;;
                -d)
                    COMPREPLY=($(compgen -W "project description head pending version created languages dependencies authors last-change contributors url commits churn lines-of-code size license" -- "${cur}"))
                    return 0
                    ;;
                --number-of-authors)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --number-of-languages)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --number-of-file-churns)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --churn-pool-size)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -e)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --no-bots)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --type)
                    COMPREPLY=($(compgen -W "programming markup prose data" -- "${cur}"))
                    return 0
                    ;;
                -T)
                    COMPREPLY=($(compgen -W "programming markup prose data" -- "${cur}"))
                    return 0
                    ;;
                --text-colors)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -t)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --number-separator)
                    COMPREPLY=($(compgen -W "plain comma space underscore" -- "${cur}"))
                    return 0
                    ;;
                --ascii-input)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --ascii-colors)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -c)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --ascii-language)
                    COMPREPLY=($(compgen -W "abnf abap ada agda arduino assembly autohotkey bash c cmake c# ceylon clojure coffeescript coldfusion coq c++ crystal css d dart dockerfile emacs-lisp elixir elm emojicode erlang f# fish forth fortran fortranmodern gdscript glsl go graphql groovy haskell haxe hcl hlsl holyc html idris java javascript json jsonnet jsx julia jupyter-notebooks kotlin llvm lisp lua makefile markdown nim nix ocaml objective-c odin org oz pascal perl raku php powershell processing prolog protocol-buffers purescript python qml r racket renpy ruby rust sass scala scheme shell solidity sql svelte svg swift systemverilog tcl tex toml tsx typescript vala verilog vhdl vimscript visualbasic vue webassembly wolfram xsl xaml xml yaml zig zsh" -- "${cur}"))
                    return 0
                    ;;
                -a)
                    COMPREPLY=($(compgen -W "abnf abap ada agda arduino assembly autohotkey bash c cmake c# ceylon clojure coffeescript coldfusion coq c++ crystal css d dart dockerfile emacs-lisp elixir elm emojicode erlang f# fish forth fortran fortranmodern gdscript glsl go graphql groovy haskell haxe hcl hlsl holyc html idris java javascript json jsonnet jsx julia jupyter-notebooks kotlin llvm lisp lua makefile markdown nim nix ocaml objective-c odin org oz pascal perl raku php powershell processing prolog protocol-buffers purescript python qml r racket renpy ruby rust sass scala scheme shell solidity sql svelte svg swift systemverilog tcl tex toml tsx typescript vala verilog vhdl vimscript visualbasic vue webassembly wolfram xsl xaml xml yaml zig zsh" -- "${cur}"))
                    return 0
                    ;;
                --true-color)
                    COMPREPLY=($(compgen -W "auto never always" -- "${cur}"))
                    return 0
                    ;;
                --image)
                    local oldifs
                    if [[ -v IFS ]]; then
                        oldifs="$IFS"
                    fi
                    IFS=$'\n'
                    COMPREPLY=($(compgen -f "${cur}"))
                    if [[ -v oldifs ]]; then
                        IFS="$oldifs"
                    fi
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o filenames
                    fi
                    return 0
                    ;;
                -i)
                    local oldifs
                    if [[ -v IFS ]]; then
                        oldifs="$IFS"
                    fi
                    IFS=$'\n'
                    COMPREPLY=($(compgen -f "${cur}"))
                    if [[ -v oldifs ]]; then
                        IFS="$oldifs"
                    fi
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o filenames
                    fi
                    return 0
                    ;;
                --image-protocol)
                    COMPREPLY=($(compgen -W "kitty sixel iterm" -- "${cur}"))
                    return 0
                    ;;
                --color-resolution)
                    COMPREPLY=($(compgen -W "16 32 64 128 256" -- "${cur}"))
                    return 0
                    ;;
                --output)
                    COMPREPLY=($(compgen -W "json yaml" -- "${cur}"))
                    return 0
                    ;;
                -o)
                    COMPREPLY=($(compgen -W "json yaml" -- "${cur}"))
                    return 0
                    ;;
                --generate)
                    COMPREPLY=($(compgen -W "bash elvish fish powershell zsh" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _onefetch -o nosort -o bashdefault -o default onefetch
else
    complete -F _onefetch -o bashdefault -o default onefetch
fi
