
using namespace System.Management.Automation
using namespace System.Management.Automation.Language

Register-ArgumentCompleter -Native -CommandName 'ncspot' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $commandElements = $commandAst.CommandElements
    $command = @(
        'ncspot'
        for ($i = 1; $i -lt $commandElements.Count; $i++) {
            $element = $commandElements[$i]
            if ($element -isnot [StringConstantExpressionAst] -or
                $element.StringConstantType -ne [StringConstantType]::BareWord -or
                $element.Value.StartsWith('-') -or
                $element.Value -eq $wordToComplete) {
                break
        }
        $element.Value
    }) -join ';'

    $completions = @(switch ($command) {
        'ncspot' {
            [CompletionResult]::new('-d', 'd', [CompletionResultType]::ParameterName, 'Enable debug logging to the specified file')
            [CompletionResult]::new('--debug', 'debug', [CompletionResultType]::ParameterName, 'Enable debug logging to the specified file')
            [CompletionResult]::new('-b', 'b', [CompletionResultType]::ParameterName, 'custom basepath to config/cache files')
            [CompletionResult]::new('--basepath', 'basepath', [CompletionResultType]::ParameterName, 'custom basepath to config/cache files')
            [CompletionResult]::new('-c', 'c', [CompletionResultType]::ParameterName, 'Filename of config file in basepath')
            [CompletionResult]::new('--config', 'config', [CompletionResultType]::ParameterName, 'Filename of config file in basepath')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('-V', 'V ', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('info', 'info', [CompletionResultType]::ParameterValue, 'Print platform information like paths')
            [CompletionResult]::new('help', 'help', [CompletionResultType]::ParameterValue, 'Print this message or the help of the given subcommand(s)')
            break
        }
        'ncspot;info' {
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'ncspot;help' {
            [CompletionResult]::new('info', 'info', [CompletionResultType]::ParameterValue, 'Print platform information like paths')
            [CompletionResult]::new('help', 'help', [CompletionResultType]::ParameterValue, 'Print this message or the help of the given subcommand(s)')
            break
        }
        'ncspot;help;info' {
            break
        }
        'ncspot;help;help' {
            break
        }
    })

    $completions.Where{ $_.CompletionText -like "$wordToComplete*" } |
        Sort-Object -Property ListItemText
}
